/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server.util;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.localization.LogMessages;
import org.glassfish.grizzly.ssl.SSLBaseFilter;
import org.glassfish.grizzly.ssl.SSLSupportImpl;

public class RequestUtils {
    private static final Logger LOGGER = Grizzly.logger(RequestUtils.class);

    public static Object populateCertificateAttribute(Request request) {
        Object[] certificates = null;
        if (request.getRequest().isSecure()) {
            if (request.getRequest().getUpgradeDC().isNull()) {
                try {
                    request.getInputBuffer().fillFully(request.getHttpFilter().getConfiguration().getMaxBufferedPostSize());
                }
                catch (IOException e) {
                    throw new IllegalStateException("Can't complete SSL re-negotation", e);
                }
            }
            SSLBaseFilter.CertificateEvent event = new SSLBaseFilter.CertificateEvent(true);
            request.getContext().notifyDownstream(event);
            certificates = event.getCertificates();
            request.setAttribute("javax.servlet.request.X509Certificate", certificates);
        }
        return certificates;
    }

    public static void populateSSLAttributes(Request request) {
        block9: {
            if (request.isSecure()) {
                try {
                    SSLSupportImpl sslSupport = new SSLSupportImpl(request.getContext().getConnection());
                    Object sslO = sslSupport.getCipherSuite();
                    if (sslO != null) {
                        request.setAttribute("javax.servlet.request.cipher_suite", sslO);
                    }
                    if ((sslO = sslSupport.getPeerCertificateChain(false)) != null) {
                        request.setAttribute("javax.servlet.request.X509Certificate", sslO);
                    }
                    if ((sslO = sslSupport.getKeySize()) != null) {
                        request.setAttribute("javax.servlet.request.key_size", sslO);
                    }
                    if ((sslO = sslSupport.getSessionId()) != null) {
                        request.setAttribute("javax.servlet.request.ssl_session_id", sslO);
                    }
                    break block9;
                }
                catch (Exception ioe) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Unable to populate SSL attributes", ioe);
                    }
                    break block9;
                }
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Unable to populate SSL attributes on plain HTTP request");
            }
        }
    }

    public static void handleSendFile(Request request) {
        Object f2 = request.getAttribute("org.glassfish.grizzly.http.SEND_FILE");
        if (f2 != null) {
            Response response = request.getResponse();
            if (response.isCommitted()) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVER_REQUESTUTILS_SENDFILE_FAILED());
                }
                return;
            }
            File file = (File)f2;
            Long offset = (Long)request.getAttribute("org.glassfish.grizzly.http.FILE_START_OFFSET");
            Long len = (Long)request.getAttribute("org.glassfish.grizzly.http.FILE_WRITE_LEN");
            if (offset == null) {
                offset = 0L;
            }
            if (len == null) {
                len = file.length();
            }
            response.getOutputBuffer().sendfile(file, offset, len, null);
        }
    }
}

